#!/bin/python
import RPi.GPIO as GPIO # importeer de GPIO bibliotheek.
from time import sleep # importeer de time biblotheek voor tijdfuncties.

GPIO.setmode(GPIO.BCM) # Zet de pinmode op Broadcom SOC.
GPIO.setwarnings(False) # Zet waarschuwingen uit.

led=5 # GPIO pin als LED variabele declareren
pir=16 # GPIO pin als PIR variabele declareren
buzzer=18 # GPIO pin als BUZZER variabele declareren


# Zet de GPIO pinnen als in- of uitgang.
GPIO.setup(buzzer, GPIO.OUT) # buzzer
GPIO.setup(led, GPIO.OUT) # led
GPIO.setup(pir, GPIO.IN) # pir


def alarm(duur,pauze):
        GPIO.output(led, 1)
        GPIO.output(buzzer,1)
        print("alarm duur" ,duur, "pauze" ,pauze )
        sleep(duur)
        GPIO.output(led, 0)
        GPIO.output(buzzer, 0)
        sleep(pauze)

while True:

    if GPIO.input(pir)== 0:
        alarm(0.01,2)
        print("PIR = 0, geen beweging...")

    else:
        alarm(0.01,0.1)
        print("PIR <> 0, wel beweging...")
   

